using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication
{
    public class Student : Gemini.Core.WebApplication.Base.WebPageComponent
    {
        public Student(Gemini.Core.WebApplication.Interface.IWebPageComponentParam WebPageComponentParam): base(WebPageComponentParam){}

        private BL.ZSBELearning _blZSBELearning = null;
        public BL.ZSBELearning ZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        private bool _studentrestored = false;
        private BL.BO.Student _student = null;
        private BL.BO.Student BOStudent
        {
            get
            {
                if (!_studentrestored)
                {
                    _student = ZSBELearning.Student.RestoreByUser(Environment.User);
                    _studentrestored = true;
                }
                return _student;
            }
        }

        public override long ClientID
        {
            get { return ZSBELearning.ClientID; }
        }

        public override bool Save()
        {
            return true;
        }

        public override void Load()
        {
            try
            {
                if (WebPageEngine.IsUserAuthorized)
                {
                    if (BOStudent == null)
                    {
                        return;
                    }

                    XML.Element.Add("StudentUser", 1);
                    
                    PI.FM.N001.Account.BL.BO.User _user = Environment.User as PI.FM.N001.Account.BL.BO.User;
                    if (_user != null)
                    {
                        XML.Element.Start("User");
                        XML.Element.Attribute("CountLogin", _user.CountLogin);
                        XML.Element.Attribute("DateLastInvalidLogin", _user.DateLastInvalidLogin, Gemini.Utility.Normalize.DateTimeFormatType.Full);
                        XML.Element.Attribute("DateLastLogin", _user.DateLastLogin, Gemini.Utility.Normalize.DateTimeFormatType.Full);
                        XML.Element.End();
                    }

                    BL.BO.StudentDoc _studentDoc = ZSBELearning.StudentDoc.Restore(_student, PI.ZB.N1200.ELearning.BL.PDFReport.Config.CERTYFIKAT_NAME);
                    XML.Element.Start("Student");
                    XML.Element.Attribute("CurrentAdvancedLevelID", BOStudent.CurrentAdvancedLevelID);
                    XML.Element.Attribute("CompetenceEvaluationSheetID", BOStudent.CompetenceEvaluationSheetID);
                    XML.Element.Attribute("ClassID", BOStudent.ClassID);
                    XML.Element.Attribute("Email", BOStudent.Email);
                    XML.Element.Attribute("Forename", BOStudent.Forename);
                    XML.Element.Attribute("ID", BOStudent.ID);
                    XML.Element.Attribute("IndexNr", BOStudent.IndexNr);
                    XML.Element.Attribute("Sex", BOStudent.Sex);
                    XML.Element.Attribute("Surename", BOStudent.Surename);
                    XML.Element.Attribute("UserBID", BOStudent.UserID);
                    XML.Element.Attribute("IsCertifikat", _studentDoc != null ? "1" : "0");
                    XML.Element.Attribute("CertifikatPath", _studentDoc != null ? _studentDoc.Path : String.Empty);
                    XML.Element.Attribute("CertifikatName", _studentDoc != null ? _studentDoc.Name : String.Empty);
                    XML.Element.Attribute("CertifikatDate", _studentDoc != null ? _studentDoc.Extension.CreateDate : DateTime.MinValue, Gemini.Utility.Normalize.DateTimeFormatType.Full);
                    XML.Element.End();

                    BL.BO.Class _class = ZSBELearning.Class.Restore(BOStudent);
                    XML.Element.Start("Class");
                    XML.Element.Attribute("ID", _class.ID);
                    XML.Element.Attribute("InstructorID", _class.InstructorID);
                    XML.Element.Attribute("Name", _class.Name);
                    XML.Element.Attribute("SchoolID", _class.SchoolID);
                    XML.Element.End();

                    BL.BO.School _school = ZSBELearning.School.Restore(_class.SchoolID);
                    XML.Element.Start("School");
                    XML.Element.Attribute("AddressLine1", _school.AddressLine1);
                    XML.Element.Attribute("AddressLine2", _school.AddressLine2);
                    XML.Element.Attribute("Email", _school.Email);
                    XML.Element.Attribute("Fax", _school.Fax);
                    XML.Element.Attribute("ID", _school.ID);
                    XML.Element.Attribute("Name", _school.Name);
                    XML.Element.Attribute("PostCode", _school.PostCode);
                    XML.Element.Attribute("Tel", _school.Tel);
                    XML.Element.Attribute("Town", _school.Town);
                    XML.Element.End();

                    BL.BO.Instructor _instructor = ZSBELearning.Instructor.Restore(_class.InstructorID);
                    XML.Element.Start("Instructor");
                    XML.Element.Attribute("Email", _instructor.Email);
                    XML.Element.Attribute("Forename", _instructor.Forename);
                    XML.Element.Attribute("ID", _instructor.ID);
                    XML.Element.Attribute("SchoolID", _instructor.SchoolID);
                    XML.Element.Attribute("Surename", _instructor.Surename);
                    XML.Element.Attribute("Tel", _instructor.Tel);
                    XML.Element.Attribute("Title", _instructor.Title);
                    XML.Element.End();
                }
            }
            catch (Exception _exception)
            {
                Gemini.Utility.Debug.SendExeptionViaEmali(Environment.ProjectName,_exception, String.Format("{0}{1}", Environment.Domain, Environment.URL));
                throw _exception;
            }
        }

        public override bool IsValid
        {
            get { return  ((WebPageEngine.IsUserAuthorized) && (BOStudent != null)); }
        }

        public override bool IsParamKey(long ParamKey)
        {
            return false;
        }

        public override object GetParamKey(long ParamKey, params object[] Params)
        {
            return null;
        }
    }
}